document.addEventListener('DOMContentLoaded', function () {
    console.log("JavaScript Loaded");
        console.log("DOM Loaded");


    // ==============
    // تشغيل التنقل الذاتي للكاروسيل (الهيدر)
    // ==============
    const heroCarousel = document.getElementById('heroCarousel');
    console.log("Carousel Element:", heroCarousel);
    

    if (heroCarousel) {
        const carousel = new bootstrap.Carousel(heroCarousel, {
            interval: 3000,
            ride: 'carousel',
            wrap: true
        });
        // يبدأ التنقل تلقائيًا بمجرد إنشاء الكائن
        console.log("Carousel started with 3s interval.");
    } else {
        console.log("Carousel element not found. Check ID or page content.");
    }

    // ==============
    // إخفاء رسائل الفلاش بعد 2 ثانية مع تأثير سلس
    // ==============
    const flashMessages = document.querySelectorAll('.flash-message');
    flashMessages.forEach(alert => {
        setTimeout(() => {
            alert.style.opacity = '0';
            alert.style.transform = 'translateY(-10px)';
            setTimeout(() => {
                if (alert.parentNode) {
                    alert.remove();
                }
            }, 400);
        }, 2000);
    });

 

    // ==============
    // وظائف تأكيد الحذف
    // ==============
    const deleteButtons = document.querySelectorAll('[data-confirm-delete]');
    deleteButtons.forEach(button => {
        button.addEventListener('click', function (e) {
            const type = this.getAttribute('data-confirm-delete');
            let message = 'هل أنت متأكد من الحذف؟';

            if (type === 'brand') {
                message = 'حذف العلامة؟ سيتم حذف جميع منتجاتها!';
            } else if (type === 'message') {
                message = 'هل تريد حذف هذه الرسالة؟';
            } else if (type === 'product') {
                message = 'هل أنت متأكد من حذف هذا المنتج؟';
            } else if (type === 'hero') {
                message = 'هل تريد حذف هذه الصورة؟';
            }
            else if (type === 'gallery') {
                message = 'هل تريد حذف هذه الصورة من المعرض؟';
            }
            if (!confirm(message)) {
                e.preventDefault();
            }
        });
    });
});